from azureml.core import Run
new_run=Run.get_context()
ws= new_run.experiment.workspace

import argparse
parser=argparse.ArgumentParser()
parser.add_argument('--n_estimators', type=int)
parser.add_argument('--min_samples_leaf', type=int)
parser.add_argument('--input-data', type=str)
args=parser.parse_args()
ne=args.n_estimators
msl=args.min_samples_leaf

import pandas as pd
df= new_run.input_datasets['raw_data'].to_pandas_dataframe()
y= df ['Weather Type']
x= df.drop('Weather Type',axis=1)

x=pd.get_dummies(x)
train_dummy_cols=x.columns

from sklearn.model_selection import train_test_split
x_train,x_test,y_train,y_test=train_test_split(x,y, test_size=0.2, random_state=0)
from sklearn.ensemble import RandomForestClassifier
classifier=RandomForestClassifier(n_estimators=500,criterion='entropy',random_state=0)
model=classifier.fit(x_train,y_train)
y_pred=model.predict(x_test)

from sklearn.metrics import confusion_matrix, accuracy_score,f1_score
Accuracy=accuracy_score(y_test,y_pred)
f1_score=f1_score(y_test,y_pred, average='micro')

# log results
new_run.log ('accuracy_score', value=Accuracy)
new_run.log ('f1_score', value=f1_score)

#save model
#import os
#import joblib
#model_file= './outputs/weather_model.pkl'
#os.makedirs('outputs',exist_ok=True)
#joblib.dump(value=['model'],filename=model_file)


new_run.complete()
